<?php
	use Jet_Smart_Filters\Listing\Controller as Listing_Controller;

	global $post;

	$from_tax  = $attributes['from_tax'];
	$show_all  = $attributes['show_all_terms'];
	$limit     = $attributes['terms_num'];
	$order_by  = $attributes['order_by'];
	$order     = $attributes['order'];
	$is_linked = $attributes['terms_linked'];
	$delimiter = $attributes['terms_delimiter'];
	$prefix    = $attributes['terms_prefix'];
	$suffix    = $attributes['terms_suffix'];

	$delimiter_html = $delimiter
		? '<div class="jsf-listing-terms-delimiter">' . $delimiter . '</div>'
		: '';

	$args = [
		'orderby' => $order_by,
		'order'   => $order,
	];

	if ( ! $show_all && ! empty( $limit ) ) {
		$args['limit'] = intval( $limit );
	}

	$terms = Listing_Controller::instance()->helpers->utils->get_post_terms_list( $post, $from_tax, $args );

	if ( empty( $terms ) ) {
		return;
	}

	$term_items = [];

	foreach ( $terms as $term ) {
		$item = esc_html( $term->name );

		if ( $is_linked ) {
			$url = get_term_link( $term );

			if ( ! is_wp_error( $url ) ) {
				$item = sprintf( '<a href="%s" class="jsf-listing-terms-item">%s</a>', esc_url( $url ), $item );
			}
		} else {
			$item = sprintf( '<div class="jsf-listing-terms-item">%s</div>', $item );
		}

		$term_items[] = $item;
	}

	echo '<div class="jsf-listing-terms-block">';
		echo '<div class="jsf-listing-terms">';

			if ( $prefix ) {
				echo '<div class="jsf-listing-terms-prefix">' . $prefix . '</div>';
			}

			echo implode( $delimiter_html, $term_items );

			if ( $suffix ) {
				echo '<div class="jsf-listing-terms-suffix">' . $suffix . '</div>';
			}

		echo '</div>';
	echo '</div>';
?>